﻿Imports System.IO
Imports System.Threading
Imports CT_NFC_C3x5_Lib
Public Class Form_Main
    Dim NFCReader As New Reader
    Dim ReaderStatus As Reader.ResponseFlag
    Dim Result_ISO14443A_Req_Anti_Select As New Result.ISO14443A.Req_Anti_Select

    Dim NDEF As New NDEF_Tool.NDEF


    'for Lot File
    Private sw_Lot As StreamWriter
    Private sw_Log As StreamWriter
    Private Sub Form_Main_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Directory.CreateDirectory(Application.StartupPath & "\Log")
        WriteLogFile("Main Form Load.")
    End Sub

    Private Sub cob_COMPortList_Click(sender As Object, e As EventArgs) Handles cob_COMPortList.Click

        cob_COMPortList.Items.Clear()
        cob_COMPortList.Items.AddRange(NFCReader.Dev_GetPort())

    End Sub

    Private Sub btn_Connect_Click(sender As Object, e As EventArgs) Handles btn_Connect.Click

        ReaderStatus = NFCReader.Dev_Open(cob_COMPortList.SelectedItem.ToString)
        Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.Dev_Open", ReaderStatus.ToString))
    End Sub

    Private Sub Btn_Disconnect_Click(sender As Object, e As EventArgs) Handles btn_Disconnect.Click

        ReaderStatus = NFCReader.Dev_Close()
        Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.Dev_Close", ReaderStatus.ToString))
    End Sub

    Private Sub Btn_ISO14443A_Config_Click(sender As Object, e As EventArgs) Handles btn_ISO14443A_Config.Click
        ReaderStatus = NFCReader.ISO14443A_Config()
        Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.ISO14443A_Config", ReaderStatus.ToString))
    End Sub

    Private Sub Btn_ISO14443A_SetTXRXSpeed_Click(sender As Object, e As EventArgs) Handles btn_ISO14443A_SetTXRXSpeed.Click
        ReaderStatus = NFCReader.ISO14443A_SetSpeed(Setup.ISO14443A.SpeedTx.Spd_106Kb, Setup.ISO14443A.SpeedRx.Spd_106Kb)
        Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.ISO14443A_SetSpeed", ReaderStatus.ToString))
    End Sub

    Private Sub Btn_ISO14443A_GetUID_Click(sender As Object, e As EventArgs) Handles btn_ISO14443A_GetUID.Click
        ReaderStatus = NFCReader.ISO14443A_Req_Anti_Select(Setup.ISO14443A.ReqMode.RequestCmd, Setup.ISO14443A.CollisionMarkValue.MaskZero, Result_ISO14443A_Req_Anti_Select)
        Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.ISO14443A_Req_Anti_Select", ReaderStatus.ToString))

        If ReaderStatus = Reader.ResponseFlag.Operation_success Then
            Debug.Print(String.Format("UID:{0}", BitConverter.ToString(Result_ISO14443A_Req_Anti_Select.UID).Replace("-", "")))
        End If


    End Sub

    Private Sub Btn_Generate_URL_NDEF_Click(sender As Object, e As EventArgs) Handles btn_Generate_URL_NDEF.Click
        txt_NDEF_Msg_RawData.Text = ""
        NDEF.Setting(NDEF_Tool.NDEF.NDEFTypes.URL, txt_URL.Text)
        txt_NDEF_Msg_RawData.Text = NDEF.MessageData
        'txt_NDEF_Msg_RawData.Text = BitConverter.ToString(NDEF.MessageByte).Replace("-","")
    End Sub

    Private Sub btn_WriteNDEFtoNTag_Click(sender As Object, e As EventArgs) Handles btn_WriteNDEFtoNTag.Click
        Dim NTagBlockSize As Integer = 4
        Dim TempLength As Integer = NDEF.MessageByte.Length Mod NTagBlockSize
        Dim TempNDEFArray(0) As Byte

        If TempLength > 0 Then
            ReDim Preserve TempNDEFArray(NDEF.MessageByte.Length + (NTagBlockSize - TempLength) - 1)
        Else
            ReDim Preserve TempNDEFArray(NDEF.MessageByte.Length - 1)
        End If
        Array.Copy(NDEF.MessageByte, TempNDEFArray, NDEF.MessageByte.Length)

        Dim StartBlockAddress As Integer = 4
        Dim EndBlockAddress As Integer = StartBlockAddress + CInt(TempNDEFArray.Length / NTagBlockSize) - 1

        For i = StartBlockAddress To EndBlockAddress

            Dim Address As Byte = i
            Dim WriteData(NTagBlockSize - 1) As Byte
            Array.Copy(TempNDEFArray, ((i - StartBlockAddress) * NTagBlockSize), WriteData, 0, NTagBlockSize)

            ReaderStatus = NFCReader.MifareUltralight_WriteBlock(Address, WriteData)
            Debug.Print(String.Format("Function:{0}[{1}] Status:{2}", "NFCReader.MifareUltralight_WriteBlock", Address, ReaderStatus.ToString))

        Next
    End Sub


    Protected Friend IsPolling As Boolean = False
    Private Thread_PollingTagInfo As Thread
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles btn_StartPolling.Click

        StartPolling()



    End Sub

    Public Sub StartPolling()

        If Thread_PollingTagInfo Is Nothing Then
            Thread_PollingTagInfo = New Thread(AddressOf Polling)
            Thread_PollingTagInfo.IsBackground = True
            Thread_PollingTagInfo.Start()
            IsPolling = True
            count = 0

        Else
            Thread_PollingTagInfo.Resume()
            IsPolling = True

        End If

        btn_StartPolling.Enabled = False
        btn_StopPolling.Enabled = True

    End Sub

    Dim count As Integer = 0
    Public Sub Polling()

        While (IsPolling)
            count += 1
            Debug.Print(String.Format("Loop Count:{0}", count))
            WriteLogFile(String.Format("Loop Count:{0}", count))
            NFCReader.Device_TurnOnField()
            ReaderStatus = NFCReader.ISO14443A_Req_Anti_Select(Setup.ISO14443A.ReqMode.RequestCmd, Setup.ISO14443A.CollisionMarkValue.MaskZero, Result_ISO14443A_Req_Anti_Select)
            Debug.Print(String.Format("Function:{0} Status:{1}", "NFCReader.ISO14443A_Req_Anti_Select", ReaderStatus.ToString))
            WriteLogFile(String.Format("Function:{0} Status:{1}", "NFCReader.ISO14443A_Req_Anti_Select", ReaderStatus.ToString))
            If ReaderStatus = Reader.ResponseFlag.Operation_success Then
                Debug.Print(String.Format("[{0}] UID:{1}", Now.ToString("yyyy/MM/dd HH:mm:ss.fff"), BitConverter.ToString(Result_ISO14443A_Req_Anti_Select.UID).Replace("-", "")))

                WriteLogFile(String.Format("[{0}] UID:{1}", Now.ToString("yyyy/MM/dd HH:mm:ss.fff"), BitConverter.ToString(Result_ISO14443A_Req_Anti_Select.UID).Replace("-", "")))
            End If

            NFCReader.Device_TurnOffField()

        End While

    End Sub

    Private Sub btn_StopPolling_Click(sender As Object, e As EventArgs) Handles btn_StopPolling.Click
        StopPolling()
    End Sub


    Public Sub StopPolling()
        'IsPolling = False
        If Thread_PollingTagInfo Is Nothing Then
        Else
            If Thread_PollingTagInfo.ThreadState = ThreadState.Suspended Then
            Else
                IsPolling = False
                count = 0
                Thread_PollingTagInfo.Suspend()
            End If
        End If

        btn_StartPolling.Enabled = True
        btn_StopPolling.Enabled = False
    End Sub

    Public Sub WriteLogFile(ByVal msg As String)
        '#If DEBUG Then
        Me.sw_Log = New StreamWriter(String.Format("{0}{1}.txt", Application.StartupPath & "\Log" & "\", DateTime.Now.ToString("yyyy-MM-dd")), True)

        Me.sw_Log.WriteLine(msg)

        Me.sw_Log.Flush()
        Me.sw_Log.Close()
        '#End If
    End Sub
End Class
